%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This script guides the user through the FEM approximation of tube
%diffusion for our Laplace-Beltrami Model.  The inputs are function handles
%The chief output are the time and spline variables.
%Author: Colin
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Gather Input from User
Type = input('Is this a Dirichlet problem(1) or a Neumann problem(2):'); %Establish the problem
Geometry = input('Is this on a tube(1) or our model flat space(2):');
%Geometry = 1; %Add the standardized Flat Case Later
rinc = input('Mesh step size over the unit radius:'); %Get Mesh Parameters
rnum = input('Number of nodes along tube height:');
ainc = input('Mesh step size over the 2pi angle:');

r0 = input('Tube Radius:'); %Get tube parameters
h0 = input('Tube Cylinder Length:');
D0 = input('Diffusion Coefficient:');

tstep = input('Time Sample Increment:');
tfinal = input('Final Time Sampled:');

cinitial = input('Initial Data as Function Handle:');
if Type == 2
    Ndata = input('Neumann Data on Boundary of Physical Space as Function Handle:');
end


%Generate Mesh, Lists and convert coeffs and functions to splines
dt = Mesh_D(rinc,rnum,ainc);
[Edge, Etri, Boundary, Vmem, Vnodal, Enodal, Nodal, Nodal_Bud, Nodes, Ntri, Nmem] = Lists(dt.Triangulation,dt.X);
i = 1; %For Finding (0,0) node. Here, we'll need to fix artifical Matlab error.
while Nodes(i,1)~= 0 || Nodes(i,2) ~= 0
    i = i + 1;
end

k = zeros(size(Nodes,1),1)+D0;
cinitialn = arrayfun(cinitial, Nodes(:,1), Nodes(:,2));
if Geometry == 1 %Tube Simulation
    A = @(x,y,r,h)(16*(r)^2./(1+4.*x.^2+4.*y.^2)^(2)).*(sqrt(x.^2+y.^2)<=1/2)+2*h.*r./sqrt(x.^2+y.^2).*(sqrt(x.^2+y.^2)>1/2);
    C11 = @(x,y,r,h)(sqrt(x.^2+y.^2)<=1/2)+1./(2.*h.*r.*sqrt(x.^2+y.^2)).*((r.^2).*(x.^2).*(y.^2)./(x.^2+y.^2).^2+(r.^2).*(x.^4)./(x.^2+y.^2).^2+4.*(h.^2).*y.^2).*(sqrt(x.^2+y.^2)>1/2);
    C12 = @(x,y,r,h)1./(2.*h.*r.*sqrt(x.^2+y.^2)).*((r.^2).*x.*(y.^3)./(x.^2+y.^2).^2+(r.^2).*(x.^3).*y./(x.^2+y.^2).^2-4.*(h.^2).*x.*y).*(sqrt(x.^2+y.^2)>1/2);
    C21 = @(x,y,r,h)1./(2.*h.*r.*sqrt(x.^2+y.^2)).*((r.^2).*x.*(y.^3)./(x.^2+y.^2).^2+(r.^2).*(x.^3).*y./(x.^2+y.^2).^2-4.*(h.^2).*x.*y).*(sqrt(x.^2+y.^2)>1/2);
    C22 = @(x,y,r,h)(sqrt(x.^2+y.^2)<=1/2)+1./(2.*h.*r.*sqrt(x.^2+y.^2)).*((r.^2).*(y.^4)./(x.^2+y.^2).^2+(r.^2).*(x.^2).*(y.^2)./(x.^2+y.^2).^2+4.*(h.^2).*x.^2).*(sqrt(x.^2+y.^2)>1/2);
    
    An = arrayfun(@(x,y) A(x,y,r0,h0), Nodes(:,1), Nodes(:,2));     %These will have artifical matlab NaN error wherever (0,0) node is
    C11n = arrayfun(@(x,y) C11(x,y,r0,h0), Nodes(:,1), Nodes(:,2));
    C12n = arrayfun(@(x,y) C12(x,y,r0,h0), Nodes(:,1), Nodes(:,2));
    C21n = arrayfun(@(x,y) C21(x,y,r0,h0), Nodes(:,1), Nodes(:,2));
    C22n = arrayfun(@(x,y) C22(x,y,r0,h0), Nodes(:,1), Nodes(:,2));

    An(i,1) = 16*r0^2; %Fix the errors at (0,0) vertex.
    C11n(i,1) = 1;
    C12n(i,1) = 0;
    C21n(i,1) = 0;
    C22n(i,1) = 1;
else %Flat Simulation
    varphi = @(rho) ( sqrt(2)*r0 + 2*( sqrt(2*r0^2+2*r0*h0)-sqrt(2)*r0 )*(rho - .5) )/...   %This data for the [x>= .5] region.
                    rho;                                                                   %
    dvarphi = @(rho) ( sqrt(2*r0^2+2*r0*h0) - 2*sqrt(2)*r0 )/(rho.^2);                     %These are matrix entries of D\sigma2
    M11 = @(x,y) x.^2./sqrt(x.^2+y.^2).*dvarphi(sqrt(x.^2+y.^2)) + varphi(sqrt(x.^2+y.^2));%from which both \mathcal{D} the det
    M12 = @(x,y) x.*y./sqrt(x.^2+y.^2).*dvarphi(sqrt(x.^2+y.^2));                          %and the fundamental form \mathcal{F}
    M21 = @(x,y) x.*y./sqrt(x.^2+y.^2).*dvarphi(sqrt(x.^2+y.^2));                          %are formed.
    M22 = @(x,y) y.^2./sqrt(x.^2+y.^2).*dvarphi(sqrt(x.^2+y.^2)) + varphi(sqrt(x.^2+y.^2));%
    D = @(x,y)   M11(x,y).*M22(x,y) - M12(x,y).*M21(x,y);                                  %This qty is the determinant for D\sigma2
    
    %The determinant over both transformations
    A = @(x,y) (sqrt(x.^2+y.^2)<=.5)*(8*r0^2) + ...
               (sqrt(x.^2+y.^2)>.5)*(D(x,y));
    %The D *F^{-1} coefficients over both transformations
    C11 = @(x,y) (sqrt(x.^2+y.^2)<=.5).*1+...
                 (sqrt(x.^2+y.^2)>.5).*1/D(x,y).*M22(x,y);
    C12 = @(x,y) (sqrt(x.^2+y.^2)>.5).*1/D(x,y).*-1.*M12(x,y);
    C21 = @(x,y) (sqrt(x.^2+y.^2)>.5).*1/D(x,y).*-1.*M21(x,y);
    C22 = @(x,y) (sqrt(x.^2+y.^2)<=.5).*1+...
                 (sqrt(x.^2+y.^2)>.5).*1/D(x,y).*M11(x,y);
    
    %Convert to Nodals
    An = arrayfun(@(x,y) A(x,y), Nodes(:,1), Nodes(:,2));     %These will have artifical matlab NaN error wherever (0,0) node is
    C11n = arrayfun(@(x,y) C11(x,y), Nodes(:,1), Nodes(:,2));
    C12n = arrayfun(@(x,y) C12(x,y), Nodes(:,1), Nodes(:,2));
    C21n = arrayfun(@(x,y) C21(x,y), Nodes(:,1), Nodes(:,2));
    C22n = arrayfun(@(x,y) C22(x,y), Nodes(:,1), Nodes(:,2));

    An(i,1) = 8*r0^2;
    C11n(i,1) = 1;
    C12n(i,1) = 0;
    C21n(i,1) = 0;
    C22n(i,1) = 1;
    
end

if Type == 1 %Dirichlet Problem
    %
    cinitialbd = input('Initial Boundary Data as a Function Handle:'); %Allow user to control the nodes directly at boundary
    cinitialbdn = arrayfun(cinitialbd, Nodes(:,1), Nodes(:,2));
    cinitialn(Nodal_Bud(2,1)+1:Nodal_Bud(4,1),1) = cinitialbdn(Nodal_Bud(2,1)+1:Nodal_Bud(4,1),1); %Replace the original cinitial boundary with this Dirichlet data
    %
    [time, spline] = FEM_Solver_Parabolic(dt,An,k,C11n,C12n,C21n,C22n,cinitialn,tfinal,tstep);
else %Neumann Problem
    Ndatan = arrayfun(Ndata, Nodes(:,1), Nodes(:,2));
    if Geometry == 1 %This is a tube and neumann data scales like the boundary area measure r0
    Ndatan = Ndatan *r0; %Multiply by Jacobian from unit boundary to actual tube boundary
                         %so that we normalize the physical flux to the virtual flux
    else %This is the flat case and so Jacobian scales like boundary area measure \bar{r}_{2} = \sqrt{2r^{2}+2rh}
    Ndatan = Ndatan *sqrt(2*r0^2+2*r0*h0); 
    end
    [time,spline] = FEM_Solver_Parabolic_Neumann(dt,An,k,C11n,C12n,C21n,C22n,cinitialn,Ndatan,tfinal,tstep);
end

%Plot some of the output
triplot(dt) %Mesh
QSpline_Plot(dt,Q_FNodal(Ntri,Nodes,spline(:,1)),6) %Initial Data
QSpline_Plot(dt,Q_FNodal(Ntri,Nodes,spline(:,size(spline,2))),6); %Final Time Sampled
clear Type Geometry